;C prototype: void DrawBlock (short x, short y, void *sprite, void *dest, unsigned char shadow);
;
;void DrawBlock (register short x asm("%d0"),
;		 register short y asm("%d1"),
;		 register void *sprite asm("%a0"),
;		 register void *dest asm("%a1"),
;		 register unsigned char shadow asm("%d3"));

	xdef _DrawBlock

_DrawBlock:
    	add.w	d1,d1			;y*2
	move.w	d1,d2
	lsl.w	#4,d2			;y*32
	sub.w	d1,d2			;32-2=y*30

    	lsr.w    #3,d0	; d3 = x/16

    	add.w    d0,d2	; d1 = 18*y + x/16
    	adda.w   d2,a1	; a0 += offset
    	
	moveq.l	 #5,d2

\bcl_drawblock:
	move.b	 (a0)+,(a1)
	move.b	 (a0)+,1(a1)
	move.b	 (a0)+,6000(a1)
	move.b	 (a0)+,6000+1(a1)
	lea	 30(a1),a1
	dbf	 d2,\bcl_drawblock
		
;Shadow
	moveq.b  #-1,d0
	moveq.l	 #6,d2
	
	move.b	 d0,(a1)
	move.b	 d0,1(a1)
	move.b	 d0,6000(a1)
	move.b	 d0,6000+1(a1)
	lea.l	 30(a1),a1
	
	tst.b	 d3
	beq.s	 \end_drawblock
	
\bcl_block_shadow_down:
	move.b	 1(a1),d0
	move.b   6000+1(a1),d1
	
	;lightplane
	move.b	 d0,d3
	not.b	 d3
	or.b	 d1,d3
	move.b	 d3,1(a1)
	
	;darkplane
	or.b	 d0,d1
	move.b   d1,6000+1(a1)
	lea	 30(a1),a1
	dbf	 d2,\bcl_block_shadow_down
	
	lea.l	 -210(a1),a1
	moveq.l	 #6,d2

\bcl_block_shadow_right:
	move.b	 2(a1),d0
	move.b   6000+2(a1),d1
	
	;lightplane
	move.b	 d0,d3
	not.b	 d3
	or.b	 d1,d3
	move.b	 d3,2(a1)
	
	;darkplane
	or.b	 d0,d1
	move.b   d1,6000+2(a1)
	
	lea	 30(a1),a1
	dbf	 d2,\bcl_block_shadow_right
	
\end_drawblock			
	rts